﻿/* list of callbacks:
    
- onItemsAddedToProjectSuccess resp. onItemAddedToProjectSuccess
- onCopyToSharedStorageComplete
- onMissingMediaFound
- onAuthenticationSuccess (EAObject - QEDOM)
- onAuthenticationFailure (EAObject - QEDOM)
- onAuthenticateSuccess (Anywhere - DOM)
- onAuthenticateFailure (Anywhere - DOM)

 */
 
// map event "onItemsAddedToProjectSuccess" to callback "onItemAddedToProjectSuccess" 
app.addEventListener("onItemsAddedToProjectSuccess", function(eventObj)
{
    // for simlicity reasons we send in the new world only one event for all items and not as in the old world one event for every item
    if (app.onItemAddedToProjectSuccess && typeof app.onItemAddedToProjectSuccess === "function")
    {
        var projectInfo = eventObj.projectInfo;
        for (var i=0; i<eventObj.addedItems.length; ++i)
        {
            var item = eventObj.addedItems[i];
            app.onItemAddedToProjectSuccess(projectInfo, item);
        }
   }
}, false);

// map event "onCopyToSharedStorageComplete" to callback "onCopyToSharedStorageComplete"
app.addEventListener("onCopyToSharedStorageComplete", function(eventObj)
{
    if (app.onCopyToSharedStorageComplete && typeof app.onCopyToSharedStorageComplete === "function")
    {
        var productionID = eventObj.productionID;
        var mediaLocatorID = eventObj.mediaLocatorID;
        var mediaFilePath = eventObj.mediaFilePath;
        var targetPath = eventObj.targetPath;
        var transferStatus = eventObj.transferStatus;
        app.onCopyToSharedStorageComplete(productionID, mediaLocatorID, mediaFilePath, targetPath, transferStatus);
    }
}, false);
 
// map event "onMissingMediaFound" to callback "onMissingMediaFound"
app.addEventListener("onMissingMediaFound", function(eventObj)
{
    if (app.onMissingMediaFound && typeof app.onMissingMediaFound === "function")
    {
        app.onMissingMediaFound(eventObj.productionID);
    }
}, false);

// map event "EAObject.onAuthenticationSuccess" to EAObject callback "onAuthenticationSuccess" 
app.addEventListener("EAObject.onAuthenticationSuccess", function(eventObj)
{
    if (eventObj.target && eventObj.target.onAuthenticationSuccess && typeof eventObj.target.onAuthenticationSuccess === "function")
    {
        eventObj.target.onAuthenticationSuccess();
    }
}, true);

// map event "EAObject.onAuthenticationFailure" to EAObject callback "onAuthenticationFailure" 
app.addEventListener("EAObject.onAuthenticationFailure", function(eventObj)
{
    if (eventObj.target && eventObj.target.onAuthenticationFailure && typeof eventObj.target.onAuthenticationFailure === "function")
    {
        eventObj.target.onAuthenticationFailure();
    }
}, true);

// map event "onAuthenticateSuccess" 
app.anywhere.addEventListener("onAuthenticateSuccess", function(eventObj)
{
    if (app.anywhere.onAuthenticateSuccess && typeof app.anywhere.onAuthenticateSuccess === "function")
    {
        app.anywhere.onAuthenticateSuccess();
    }
}, false);

// map event "onAuthenticateFailure" 
app.anywhere.addEventListener("onAuthenticateFailure", function(eventObj)
{
    if (app.anywhere.onAuthenticateFailure && typeof app.anywhere.onAuthenticateFailure === "function")
    {
        app.anywhere.onAuthenticateFailure();
    }
}, false);

// Store anywhere events associated with listener and handler while do bind
var anywhereEventsDict = {}; 

// binding support for "app.anywhere" events
if (!app.anywhere.bind)
{
     app.anywhere.bind = function(inEventName, inHandler)
     {
           if (inHandler && typeof inHandler === 'function')
           {
                var listener = function(inEventObj)
                {
                    var info = anywhereEventsDict[inEventName];
                    if (info && info.handler && typeof info.handler === 'function')
                    {
                        info.handler();
                    }
                }
                anywhereEventsDict[inEventName] = {"listener":listener, "handler":inHandler};
                app.anywhere.addEventListener(inEventName, listener, false); 
                return true;
           }
           return false;
     }
}

// unbinding support for "app.anywhere" events
if (!app.anywhere.unbind)
{
    app.anywhere.unbind = function(inEventName, inHandler)
    {
        if (inHandler && typeof inHandler === 'function')
        {
            var info = anywhereEventsDict[inEventName];
            if (info && info.listener && typeof info.listener === 'function')
            {
                app.anywhere.removeEventListener(inEventName, info.listener);
            }
            return true;
        }
        return false;
    }
}

// setTimeout support for "app.anywhere" object
if (!app.anywhere.setTimeout)
{
    app.anywhere.setTimeout = function(inFct, inMilliseconds)
    {
        var timeoutObj = new Timeout(inMilliseconds);
        timeoutObj.addEventListener("onTimeout", function(eventObj)
        {
           if (inFct && typeof inFct === 'function') 
            {
                inFct();
            }
        }, false);
    }
}